﻿#pragma once

#if       !defined(INCLUDED_STD_VECTOR)
#include  <vector>
#endif // !defined(INCLUDED_STD_VECTOR)

#if       !defined(INCLUDED_SZ_RUNTIME_EXCEPTION)
#include  <szRuntimeException.hpp>
#endif // !defined(INCLUDED_SZ_RUNTIME_EXCEPTION)

#include  "EventHandle.hpp"
#include  "ProcessUI.hpp"
#include  "PasswordUI.hpp"

class CommandProcessorState
{
public:

  CommandProcessorState(ProcessUI *pUI);
  ~CommandProcessorState();

  const EventHandle &GetQuitEvent() const { return quitEvent; }
  const EventHandle &GetDoneEvent() const { return doneEvent; }
  EventHandle &GetQuitEvent() { return quitEvent; }
  EventHandle &GetDoneEvent() { return doneEvent; }

  bool Quitting() const { return quitEvent.Wait(0); }

  /// 入力ファイルが相対パスの場合にルートとして利用されるパス。
  const szstring &GetInputPathRoot() const { return inputPathRoot; }
  void SetInputPathRoot(const szstring &path) { inputPathRoot.assign(path); }

  /// 出力（圧縮も解凍も共通）のルートとして利用されるパス。
  const szstring &GetOutputPathRoot() const { return outputPathRoot; }
  void SetOutputPathRoot(const szstring &path) { outputPathRoot.assign(path); }

  // TODO: エラーログを記録するのもこのクラス？？？そうすればdecompressorとかに渡すことができる
  // エラー／警告などの種類も記録するように変更。

  void AddLog(const szstring &logText) { log.push_back(logText); }
  const std::vector<szstring> &GetLog() const { return log; }

  void AddLog(const szpp::RuntimeException &runtimeException);

  bool GetVerbose() const { return verbose; }
  void SetVerbose(bool verbose) { this->verbose = verbose; }

  int GetPassword(const szstring &archive, szstring *password);

private:

  ProcessUI *pUI;
  EventHandle quitEvent;
  EventHandle doneEvent;
  szstring inputPathRoot;
  szstring outputPathRoot;
  std::vector<szstring> log;

  // 所属する展開コマンドが異なるとパスワードやスキップ設定はリセットされるようにするため、
  // コマンドプロセッサの状態としてパスワード処理器を持たせている。
  PasswordUI passwordUI;
  bool verbose;
};
